//
//  Movie.h
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Fri Aug 31 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "Camera.h"
#import "All3DObjects.h"
#import "Light.h"
#import "SceneParser.h"

// This is a work in progress. At the moment it takes a start and end frame and calculates a linear tween between the two scene files. Currently camera only
@interface RayMovie : NSObject {
	int currentFrame, numKeyFrames, numFrames;
	NSMutableArray *threeDObjectsStart, *threeDObjectsEnd, *lightsStart, *lightsEnd, *materialsStart, *materialsEnd;
	Camera *cameraStart, *cameraEnd;
	RGBVector *ambientStart, *ambientEnd, *backgroundStart, *backgroundEnd;
}

- (id)initWithNumberOfKeyFrames:(int)numKeyFrames numberOfFrames:(int)numFrames;

//- (NSDictionary *)getPreviousFrame;
//- (NSDictionary *)getCurrentFrame;
- (NSDictionary *)getNextFrame;
//- (void)goNextFrame;
//- (void)goPreviousFrame;

@end
