//
//  Movie.m
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Fri Aug 31 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import "RayMovie.h"

@implementation RayMovie

- (id)initWithNumberOfKeyFrames:(int)numberOfKeyFrames numberOfFrames:(int)numberOfFrames
{
	if (self = [super init])	//initialize the object using the super class's method
	{	// super init worked.
		SceneParser *newScene = [[SceneParser alloc] init];
		cameraStart = [[Camera alloc] init];
		cameraEnd = [[Camera alloc] init];
		materialsStart = [[NSMutableArray alloc] init];
		materialsEnd = [[NSMutableArray alloc] init];
		threeDObjectsStart = [[NSMutableArray alloc] init];
		threeDObjectsEnd = [[NSMutableArray alloc] init];
		lightsStart = [[NSMutableArray alloc] init];
		lightsEnd = [[NSMutableArray alloc] init];
		ambientStart = [[RGBVector alloc] init];
		ambientEnd = [[RGBVector alloc] init];
		backgroundStart = [[RGBVector alloc] init];
		backgroundEnd = [[RGBVector alloc] init];
		numKeyFrames = (numberOfKeyFrames > 1) ? numberOfKeyFrames : 1;
		numFrames = (numberOfFrames > 1) ? numberOfFrames : 2;
		currentFrame = 0;
		if ([newScene importSceneWithCamera:cameraStart materials:materialsStart objects:threeDObjectsStart
				lights:lightsStart ambient:ambientStart background:backgroundStart filename:@"/Users/spbryson/start.plist"])
			if ([newScene importSceneWithCamera:cameraEnd materials:materialsEnd objects:threeDObjectsEnd
					lights:lightsEnd ambient:ambientEnd background:backgroundEnd filename:@"/Users/spbryson/end.plist"])
				NSLog(@"Import Successful");
		[newScene release];
		return self;
	}
	return nil; // something went wrong.
}

- (void)dealloc
{
	[cameraStart release];
	[threeDObjectsStart release];
	[lightsStart release];
	[cameraEnd release];
	[threeDObjectsEnd release];
	[lightsEnd release];
	[ambientStart release];
	[ambientEnd release];
	[super dealloc];  //use the super class's method for instance destruction
}


- (NSDictionary *)getNextFrame
{
	Camera *tempCamera = [Camera cameraWithLinearFrameStart:cameraStart end:cameraEnd currentFrame:currentFrame totalFrames:numFrames];
	RGBVector *tempAmbient = [RGBVector rgbVectorWithLinearFrameStart:ambientStart end:ambientEnd currentFrame:currentFrame totalFrames:numFrames];
	RGBVector *tempBackground = [RGBVector rgbVectorWithLinearFrameStart:backgroundStart end:backgroundEnd currentFrame:currentFrame totalFrames:numFrames];
	NSMutableArray *tempLights = [[[NSMutableArray alloc] init] autorelease];
//	NSMutableArray *tempObjects = [[[NSMutableArray alloc] init] autorelease];
	int i;

	// This is count - 1 because there will be the @"Lights" string at the end of the array (used by NSOutlineView)
	for (i = 0; i < [lightsStart count]-1; i++)
	{
		[tempLights addObject:
			[Light lightWithLinearFrameStart:[lightsStart objectAtIndex:i] end:[lightsEnd objectAtIndex:i] currentFrame:currentFrame totalFrames:numFrames]
		];
	}
	/*for (i = 0; i< [threeDObjectsStart count]-1; i++)
	{
		if ([[threeDObjectsStart objectAtIndex:i] isKindOfClass:[Sphere class]])
		{
			[tempObjects addObject:
				[Sphere sphereWithLinearFrameStart:(Sphere *)[threeDObjectsStart objectAtIndex:i] end:(Sphere *)[threeDObjectsEnd objectAtIndex:i]
						currentFrame:currentFrame totalFrames:numFrames]
			];
		}
	}*/

	currentFrame++;
	
	return [NSDictionary dictionaryWithObjects: [NSArray arrayWithObjects:tempCamera, threeDObjectsStart, tempLights, tempAmbient, tempBackground, nil]
										forKeys: [NSArray arrayWithObjects:@"Camera", @"Objects", @"Lights", @"Ambient Light", @"Background Colour", nil]];
}

@end
