//
//  Reflection.m
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Mon Oct 08 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import "Reflection.h"


@implementation Reflection
- (id)initWithDictionary:(NSDictionary *)dictionary
{
	if (self = [super initWithDictionary:dictionary])	//initialize the object using the super class's method
	{	// super init worked.
		NSArray *scale = [NSArray arrayWithArray:[dictionary valueForKey:@"Reflection Factors"]];
	
		transformation[0][0] = [scale objectAtIndex:0] ? -1 : 1;
		transformation[1][1] = [scale objectAtIndex:1] ? -1 : 1;
		transformation[2][2] = [scale objectAtIndex:2] ? -1 : 1;
		transformation[3][3] = 1;

		transformation[0][1] = transformation[0][2] = transformation[0][3] = 0;
		transformation[1][0] = transformation[1][2] = transformation[1][3] = 0;
		transformation[2][0] = transformation[2][1] = transformation[2][3] = 0;
		transformation[3][0] = transformation[3][1] = transformation[3][2] = 0;
		return self;
	}
	return nil; // something went wrong.
}

// Used when we are saving to a scene file
- (NSMutableDictionary *)asDictionary
{
	NSMutableDictionary *dictionary = [super asDictionary];
	[dictionary setObject:[NSArray arrayWithObjects:
		transformation[0][0] == 1 ? [NSNumber numberWithBool:NO] : [NSNumber numberWithBool:YES],
		transformation[1][1] == 1 ? [NSNumber numberWithBool:NO] : [NSNumber numberWithBool:YES],
		transformation[2][2] == 1 ? [NSNumber numberWithBool:NO] : [NSNumber numberWithBool:YES], nil]
		forKey:@"Reflection Factors"];
	[dictionary setObject:@"Reflection" forKey:@"Transformation Type"];
	return dictionary;
}

// Debugging
- (void)logValues
{
	NSLog(@"Transformation of type: Reflection");
	[super logValues];
}
@end
