//
//  SceneParser.h
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Sun Aug 19 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <Cocoa/Cocoa.h>
#import "Camera.h"
#import "All3DObjects.h"
#import "Light.h"


@interface SceneParser : NSObject {
	NSMutableDictionary *importedScene, *exportedScene;
}

// Main import scene function, calls the three below
- (BOOL)importSceneWithCamera:(Camera *)camera materials:(NSMutableArray *)materials objects:(NSMutableArray *)objects lights:(NSMutableArray *)lights
						ambient:(RGBVector *)ambient background:(RGBVector *)background filename:(NSString *)filename;
- (void)importCamera:(Camera *)camera;
- (void)importMaterials:(NSMutableArray *)materials;

//This is designed to be able to import just materials whether or not a scene is presently loaded
- (BOOL)importMaterialLibrary:(NSMutableArray *)materials filename:(NSString *)filename;

- (void)importObjects:(NSMutableArray *)objects materials:(NSMutableArray *)materials;
- (void)importLights:(NSMutableArray *)lights;
// Main save scene function, calls the three below
- (BOOL)saveSceneWithCamera:(Camera *)camera materials:(NSMutableArray *)materials objects:(NSMutableArray *)threeDObjects lights:(NSMutableArray *)lights
					ambient:(RGBVector *)ambient background:(RGBVector *)background filename:(NSString *)filename;
- (void)saveCamera:(Camera *)camera;
- (void)saveMaterials:(NSMutableArray *)materials;
- (void)saveObjects:(NSMutableArray *)threeDObjects;
- (void)saveLights:(NSMutableArray *)lights;

// Validate the scene file that is being imported
- (BOOL)validateScene;
- (BOOL)validateAmbientLight;
- (BOOL)validateBackgroundColour;
- (BOOL)validateCamera;

@end

