//
//  ShadingObject.h
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Fri Aug 17 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "Object3D.h"
#import "Ray.h"
#import "Light.h"

#define MAX_DISTANCE 1000000		// This is a very long way

@interface ShadingObject : NSObject {
	// The object we hit
	Object3D *object;
	// Stuff we like to know about things and what not
	Vector3D *intersection, *normal, *cameraLocation, *transIntersection;
	// The ray that hit the object
	Ray *ray;
	// All lights and objects in the scene
	NSMutableArray *lights, *objects;
	// The ambient light in the scene
	RGBVector *ambient;
	// Used for total internal reflection, used for testing if current ray is inside a transparent object
	BOOL killed, inside;
}

// Initialise with everything anyone would ever need
- (id)initWithValuesObjectPtr:(Object3D *)objectPtr intersection:(Vector3D *)newIntersection normal:(Vector3D *)newNormal ray:(Ray *)newRay
					ambient:(RGBVector *)newAmbient;

// Getters
- (Object3D *)object;
- (Vector3D *)intersection;
- (Vector3D *)transIntersection;
- (Vector3D *)normal;
- (Ray *)ray;
- (BOOL)killed;
- (BOOL)inside;

// Colour getters
- (RGBVector *)diffuseColour;
- (BOOL)isReflective;
- (BOOL)isTransparent;
- (float)globalReflection;
- (float)globalTransmission;
- (RGBVector *)attenuationColour;

// Setters
- (void)setObject:(Object3D *)newObject;
- (void)setNormal:(Vector3D *)newNormal;
- (void)setIntersection:(Vector3D *)newIntersection;
- (void)setRay:(Ray *)newRay;
- (void)setLights:(NSMutableArray *)newLights;
- (void)setObjects:(NSMutableArray *)newObjects;
- (void)setCameraLocation:(Vector3D *)newCameraLocation;
- (void)setAmbientLight:(RGBVector *)newAmbientLight;
- (void)setKilled:(BOOL)newKilled;
- (void)setInside:(BOOL)newInside;

// Used to shade the object
- (RGBVector *)localColour;
- (RGBVector *)calculateIntensity;


@end
