//
//  Sphere.h
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Fri Aug 03 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <Foundation/Foundation.h>
#import "Object3D.h"

@interface Sphere : Object3D {
	// stores the world coords of the centre of the sphere
	Vector3D *centre;
	// stores the radius
	float radius;
}

// Class methods
+ (Sphere *)sphereWithDictionary:(NSDictionary *)dictionary;
+ (Sphere *)sphereWithLinearFrameStart:(Sphere *)start end:(Sphere *)end currentFrame:(int)currentFrame totalFrames:(int)totalFrames;

// basic init method by setting the name of the object
- (id)initWithName:(NSString *)newName;

// init with dictionary takes a dictionary and initialises the data with this dictionary. This is the most common init method for us as it is really useful when parsing our scene files.
- (id)initWithDictionary:(NSDictionary *)dictionary;

// copyWithZone is needed for use by NSOutlineView which is used in our editor drawer. All classes which appear in the NSOutlineView will implement this method.
- (id)copyWithZone:(NSZone *)zone;

// as dictionary returns all the data within this object as a dictionary. Really useful when saving a scene file.
- (NSDictionary *)asDictionary;

// returns a pointer to the centre
- (Vector3D *)centre;

// returns the radius
- (float)radius;

// sets the sphere with all data relevant to a sphere. This is generally not needed since we have the dictionary
- (void)setValuesX:(float)newX y:(float)newY z:(float)newZ radius:(float)newRadius name:(NSString *)newName;

// sets the centre
- (void)setCentre:(Vector3D *)newPoint;

// sets the radius
- (void)setRadius:(float)newRadius;
//Debugging
- (void)logValues;
@end
