//
//  TextureMapping.h
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Mon Oct 15 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <math.h>
#import "Vector3D.h"
#import "Material.h"

#define PI 3.141592654
#define PIXEL_BYTES 3

#define TILED 1
#define CROPPED 2
#define SCALED 3

@interface TextureMapping : Material {
	int proportion;
	NSString *filename;
	NSBitmapImageRep *image;
}

// Getters
- (int)proportion;
- (NSString *)filename;

// Setters
- (void)setProportion:(int)newProportion;

// Convert the hitPoint to U and V coords of the image
- (NSPoint)getPixelCoords:(Vector3D *)hitPoint;

@end
