//
//  TextureMapping.m
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Mon Oct 15 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import "TextureMapping.h"


@implementation TextureMapping

// Used when we are loading a scene file
- (id)initWithDictionary:(NSDictionary *)dictionary
{
	//initialize the object using the super class's method
	if (self = [super initWithDictionary:dictionary])
	{	// super init worked.
		// initiallise diffuseColour from an array of NSNumbers
		NSString *tempProp = [NSString stringWithString:[dictionary valueForKey:@"Proportion"]];
		filename = [[NSString alloc] initWithString:[dictionary valueForKey:@"File Name"]];
		image = [[NSBitmapImageRep alloc] initWithData:[NSData dataWithContentsOfFile:filename]];

		if ([tempProp isEqualToString:@"Tiled"])
			proportion = TILED;
		else if ([tempProp isEqualToString:@"Cropped"])
			proportion = CROPPED;
		else if ([tempProp isEqualToString:@"Scaled"])
			proportion = SCALED;
//		NSLog(@"Image pixelsHigh: %d, pixelsWide: %d", [image pixelsHigh], [image pixelsWide]);
		return self;
	}
	return nil; // something went wrong.
}

// Destructor
- (void)dealloc
{
	[filename release];
	[image release];
	//use the super class's method for instance destruction
	[super dealloc];
}

// Used when we are saving to a scene file
- (NSMutableDictionary *)asDictionary
{
	NSMutableDictionary *dictionary = [super asDictionary];
	[dictionary setObject:filename forKey:@"File Name"];
	switch (proportion)
	{
		case TILED:
			[dictionary setObject:@"Tiled" forKey:@"Proportion"];
			break;
		case CROPPED:
			[dictionary setObject:@"Cropped" forKey:@"Proportion"];
			break;
		case SCALED:
			[dictionary setObject:@"Scaled" forKey:@"Proportion"];
			break;
	}
	return dictionary;
}

// Assignment method
- (void)assign:(TextureMapping *)rhs
{
	[filename release];
	filename = [[NSString alloc] initWithString:[rhs filename]];
	[image release];
	image = [[NSBitmapImageRep alloc] initWithData:[NSData dataWithContentsOfFile:filename]];
	proportion = [rhs proportion];
}

// Getters
- (int)proportion		{	return proportion;	}
- (NSString *)filename	{	return filename;	}

// Setters
- (void)setProportion:(int)newProportion	{	proportion = newProportion;		}

// Convert the hitPoint to U and V coords of the image. Since this is an abstract object, this is here for the inheritance
- (NSPoint)getPixelCoords:(Vector3D *)hitPoint		{	return NSMakePoint(0.0, 0.0);	}

@end
