//
//  Transformation.h
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Thu Sep 20 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import <Foundation/Foundation.h>

#define TRANSLATION 1
#define PITCH 2
#define YAW 3
#define ROLL 4
#define SCALE 5
#define SHEAR 6
#define REFLECTION 7

@interface Transformation : NSObject {
	float transformation[4][4];
	int type;
	BOOL propagatesToTextures;
}

- (id)initWithDictionary:(NSDictionary *)dictionary;
- (id)initAsIdentity;
- (void)assign:(Transformation *)rhs;

// as dictionary returns all the data within this object as a dictionary. Really useful when saving a scene file.
- (NSMutableDictionary *)asDictionary;

// Getters
- (int)type;
- (float)valueAtRow:(int)row col:(int)col;
- (BOOL)propagatesToTextures;

// Setters
- (void)setType:(int)newType;
- (void)setValueAtRow:(int)row col:(int)col withValue:(float)value;
- (void)setPropagatesToTextures:(BOOL)rhs;

// This is so we can calculate the inverse transformation matrix
- (Transformation *)multiplyByTransformation:(Transformation *)rhs;

// Debugging
- (void)logValues;

@end
