//
//  Transformation.m
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Thu Sep 20 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import "Transformation.h"


@implementation Transformation

- (id)init
{
	if (self = [super init])	//initialize the object using the super class's method
	{	// super init worked.
		return self;
	}
	return nil; // something went wrong.
}

- (id)initWithDictionary:(NSDictionary *)dictionary
{
	propagatesToTextures = [[dictionary valueForKey:@"Propagates To Textures"] boolValue];
	return [self init];
}

- (id)initAsIdentity
{
	if (self = [super init])	//initialize the object using the super class's method
	{	// super init worked.
		int i, j;

		for (i = 0; i < 4; i++)
			for (j = 0; j < 4; j++)
				if (i == j)
					transformation[i][j] = 1.0;
				else
					transformation[i][j] = 0.0;
		return self;
	}
	return nil; // something went wrong.
}

- (void)assign:(Transformation *)rhs
{
	int i, j;
	for (i = 0; i < 4; i++)
		for (j = 0; j < 4; j++)
			transformation[i][j] = [rhs valueAtRow:i col:j];
}

// Destructor
- (void)dealloc
{
	//use the super class's method for instance destruction
	[super dealloc];
}

// as dictionary returns all the data within this object as a dictionary. Really useful when saving a scene file.
- (NSMutableDictionary *)asDictionary
{	return [NSMutableDictionary dictionaryWithObject:[NSNumber numberWithBool:propagatesToTextures] forKey:@"Propagates To Textures"];		}

// Getters
- (int)type									{	return type;	}
- (float)valueAtRow:(int)row col:(int)col	{	return transformation[row][col];	}
- (BOOL)propagatesToTextures				{	return propagatesToTextures;	}

// Setters
- (void)setType:(int)newType				{	type = newType;	}
- (void)setValueAtRow:(int)row col:(int)col withValue:(float)value	{	transformation[row][col] = value;	}
- (void)setPropagatesToTextures:(BOOL)rhs	{	propagatesToTextures = rhs;		}

// This is so we can calculate the inverse transformation matrix
- (Transformation *)multiplyByTransformation:(Transformation *)rhs
{
	Transformation *newTrans = [[[Transformation alloc] init] autorelease];
	int i, j;
	float temp;
	
	for (i = 0; i < 4; i++)
	{
		for (j = 0; j < 4; j++)
		{
			temp	= transformation[i][0] * [rhs valueAtRow:0 col:j]
					+ transformation[i][1] * [rhs valueAtRow:1 col:j]
					+ transformation[i][2] * [rhs valueAtRow:2 col:j]
					+ transformation[i][3] * [rhs valueAtRow:3 col:j];
			[newTrans setValueAtRow:i col:j withValue:temp];
		}	// End j loop
	}	// End i loop
	
	return newTrans;
}

// Debugging
- (void)logValues
{
//	NSLog(@"%1.3f\t%1.3f\t%1.3f\t%1.3f", transformation[0][0], transformation[0][1], transformation[0][2], transformation[0][3]);
//	NSLog(@"%1.3f\t%1.3f\t%1.3f\t%1.3f", transformation[1][0], transformation[1][1], transformation[1][2], transformation[1][3]);
//	NSLog(@"%1.3f\t%1.3f\t%1.3f\t%1.3f", transformation[2][0], transformation[2][1], transformation[2][2], transformation[2][3]);
//	NSLog(@"%1.3f\t%1.3f\t%1.3f\t%1.3f", transformation[3][0], transformation[3][1], transformation[3][2], transformation[3][3]);
	propagatesToTextures ? NSLog(@"Props - YES") : NSLog(@"Props - NO");
}

@end
