//
//  Translation.m
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Mon Oct 08 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import "Translation.h"


@implementation Translation

- (id)initWithDictionary:(NSDictionary *)dictionary
{
	if (self = [super initWithDictionary:dictionary])	//initialize the object using the super class's method
	{	// super init worked.
		NSArray *translation = [NSArray arrayWithArray:[dictionary valueForKey:@"Displacement"]];
		transformation[0][0] = transformation[1][1] = transformation[2][2] = transformation[3][3] = 1;

		transformation[0][1] = transformation[0][2] = transformation[0][3] = 0;
		transformation[1][0] = transformation[1][2] = transformation[1][3] = 0;
		transformation[2][0] = transformation[2][1] = transformation[2][3] = 0;

		transformation[3][0] = -[[translation objectAtIndex:0] floatValue];
		transformation[3][1] = -[[translation objectAtIndex:1] floatValue];
		transformation[3][2] = -[[translation objectAtIndex:2] floatValue];
		return self;
	}
	return nil; // something went wrong.
}

// Used when we are saving to a scene file
- (NSMutableDictionary *)asDictionary
{
	NSMutableDictionary *dictionary = [super asDictionary];
	[dictionary setObject:[NSArray arrayWithObjects:
		[NSNumber numberWithFloat:-transformation[3][0]],
		[NSNumber numberWithFloat:-transformation[3][1]],
		[NSNumber numberWithFloat:-transformation[3][2]], nil]
		forKey:@"Displacement"];
	[dictionary setObject:@"Translation" forKey:@"Transformation Type"];
	return dictionary;
}

// Debugging
- (void)logValues
{
	NSLog(@"Transformation of type: Translation");
	[super logValues];
}
@end
