//
//  Triangle.h
//  RayTracer
//
//  Created by Stuart Bryson and Tim Keighley on Wed Sep 05 2001.
//  Copyright (c) 2001 Stuart Bryson and Tim Keighley. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "Object3D.h"

@interface Triangle : Object3D {
	Vector3D *vertexA, *vertexB, *vertexC, *normal;
}

// Class methods
+ (Triangle *)triangleWithDictionary:(NSDictionary *)dictionary;

// init with dictionary takes a dictionary and initialises the data with this dictionary. This is the most common init method for us as it is really useful when parsing our scene files.
- (id)initWithDictionary:(NSDictionary *)dictionary;
// copyWithZone is needed for use by NSOutlineView which is used in our editor drawer. All classes which appear in the NSOutlineView will implement this method.
- (id)copyWithZone:(NSZone *)zone;
// as dictionary returns all the data within this object as a dictionary. Really useful when saving a scene file.
- (NSDictionary *)asDictionary;
// Assignment method
- (void)assign:(Triangle *)rhs;

// Setters
- (void)setWithVectorsA:(Vector3D *)newA b:(Vector3D *)newB c:(Vector3D *)newC;
- (void)setVertexA:(Vector3D *)newA;
- (void)setVertexB:(Vector3D *)newB;
- (void)setVertexC:(Vector3D *)newC;

// Getters
- (Vector3D *)vertexA;
- (Vector3D *)vertexB;
- (Vector3D *)vertexC;

- (void)calculateNormal;
@end
